<?php
/**
 * Adds a meta box to the post editing screen
 */
function seller_custom_meta() {
    add_meta_box( 'seller_meta', __( 'Display Options', 'seller' ), 'seller_meta_callback', 'page','side','high' );
}
add_action( 'add_meta_boxes', 'seller_custom_meta' );

/**
 * Outputs the content of the meta box
 */
function seller_meta_callback( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'seller_nonce' );
    $seller_stored_meta = get_post_meta( $post->ID );
    ?>
    
    <p>
	    <div class="seller-row-content">
	        <label for="enable-slider">
	            <input type="checkbox" name="enable-slider" id="enable-slider" value="yes" <?php if ( isset ( $seller_stored_meta['enable-slider'] ) ) checked( $seller_stored_meta['enable-slider'][0], 'yes' ); ?> />
	            <?php _e( 'Enable Slider', 'seller' )?>
	        </label>
	        <br />
	        <label for="hide-title">
	            <input type="checkbox" name="hide-title" id="hide-title" value="yes" <?php if ( isset ( $seller_stored_meta['hide-title'] ) ) checked( $seller_stored_meta['hide-title'][0], 'yes' ); ?> />
	            <?php _e( 'Hide Page Title', 'seller' )?>
	        </label>
	        <br />
	        <label for="enable-full-width">
	            <input type="checkbox" name="enable-full-width" id="enable-full-width" value="yes" <?php if ( isset ( $seller_stored_meta['enable-full-width'] ) ) checked( $seller_stored_meta['enable-full-width'][0], 'yes' ); ?> />
	            <?php _e( 'Enable Full Width', 'seller' )?>
	        </label>
	        
	    </div>
	</p>
 
    <?php
}


/**
 * Saves the custom meta input
 */
function seller_meta_save( $post_id ) {
 
    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'seller_nonce' ] ) && wp_verify_nonce( $_POST[ 'seller_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
    // Checks for input and sanitizes/saves if needed
    if( isset( $_POST[ 'meta-text' ] ) ) {
        update_post_meta( $post_id, 'meta-text', sanitize_text_field( $_POST[ 'meta-text' ] ) );
    }
    
    // Checks for input and saves
	if( isset( $_POST[ 'enable-slider' ] ) ) {
	    update_post_meta( $post_id, 'enable-slider', 'yes' );
	} else {
	    update_post_meta( $post_id, 'enable-slider', '' );
	}
	 
	// Checks for input and saves
	if( isset( $_POST[ 'hide-title' ] ) ) {
	    update_post_meta( $post_id, 'hide-title', 'yes' );
	} else {
	    update_post_meta( $post_id, 'hide-title', '' );
	}
	
	// Checks for input and saves
	if( isset( $_POST[ 'enable-full-width' ] ) ) {
	    update_post_meta( $post_id, 'enable-full-width', 'yes' );
	} else {
	    update_post_meta( $post_id, 'enable-full-width', '' );
	}
 
}
add_action( 'save_post', 'seller_meta_save' );